//@input Component.Image medalImage
//@input Component.Image backgroundImage

script.setEntryIndex = setEntryIndex;

let medalMaterial = null;
let backgroundMaterial = null;

function setEntryIndex(entryIndex) {
    if (isNull(entryIndex)) {
        return;
    }

    if (medalMaterial) {
        medalMaterial.mainPass.textureSwitcher = entryIndex;
    }

    switch (entryIndex) {
        case 2:
            if (!isNull(backgroundMaterial)) {
                backgroundMaterial.mainPass.textureSwitcher = 2;
            }
            break;
        case 0:
        case 1:
        default:
            if (!isNull(backgroundMaterial)) {
                backgroundMaterial.mainPass.textureSwitcher = 0;
            }
            break;
    }
}

function initialize() {
    medalMaterial = script.medalImage.mainMaterial.clone();
    script.medalImage.mainMaterial = medalMaterial;

    backgroundMaterial = script.backgroundImage.mainMaterial.clone();
    script.backgroundImage.mainMaterial = backgroundMaterial;
}

initialize();
